(deftemplate block
	(slot name)
	(slot size (type INTEGER) (range 1 ?VARIABLE))
	(slot place (type SYMBOL) (allowed-symbols heap hand stack) (default ?DERIVE))
)

(deffacts blocks
	(block (name a) (size 10))
	(block (name b) (size 20))
	(block (name c) (size 30))
)

(deftemplate goal
	(slot name (type SYMBOL) (allowed-symbols stack put_down) (default ?DERIVE))
	(slot parameter (type INTEGER) (range 1 ?VARIABLE))
)


(defrule begin
	(initial-fact)
  =>
	(assert (goal (name stack) (parameter 1)))
)

(defrule stop
	?x <- (goal (name stack) (parameter ?N))
	(not (block (place heap)))
  =>
	(retract ?x)
	(halt)
)

(defrule pickup
	(goal (name stack) (parameter ?N))
	?x <- (block (name ?B1) (size ?S1) (place heap))
	(not (and (block (name ?B2&~B1) (size ?S2) (place heap))
		  (test (> ?S2 ?S1))))
  =>
	(modify ?x (place hand))
)

(defrule holding
	?x <- (goal (name stack))
	(block (place hand))
  =>
	(modify ?x (name put_down))
)

(defrule put_down
	?x <- (goal (name put_down) (parameter ?N))
	?y <- (block (place hand))
  =>
	(modify ?y (place stack))
	(modify ?x (name stack) (parameter (+ ?N 1)))
)



